%% Simulate option data for the SV model

N=10000000; %the num of simulations
nblock=10000; %divide the simulations into blocks for faster computation

polydeg=3; %third degree poly as default

expr=365; %default time to maturity 1 year

nPeriods = 100; %number of simulated periods

dt = expr/(nPeriods*365); %step size for simulation, such that dt*nPeriods=expr/366


AssetPrice = 1300;
Rate = 0.05;   %annualized value: 0.05
div=Rate/2;
V0 = 0.6644/10000*365;   %annualized value: 0.0243
ThetaV = 0.6644/10000*365;  %annualized value: 0.0243
Kappa = 0.0116*365;    %annualized value: 4.2340
SigmaV = 0.1403/100*365;   %annualized value: 0.5121
RhoSV = -0.5268;

StartState = [AssetPrice;V0];
Correlation = [1 RhoSV;RhoSV 1];
hestonObj = heston(Rate-div,Kappa,ThetaV,SigmaV,'startstate',StartState,'correlation',Correlation);

Paths=zeros(nPeriods+1,2,N);

parfor k=1:nblock
   rng(k);
  %pathi{k}=simByTransition(hestonObj,nPeriods,'NTrials',N/nblock,'DeltaTime',stp/10/365);
  pathi{k}=simByTransition(hestonObj,nPeriods,'NTrials',N/nblock,'DeltaTime',dt);
  %disp(k);
end

for k=1:nblock
    Paths(:,:,(k-1)*(N/nblock)+1:k*(N/nblock))=pathi{k};
end

Path=Paths(nPeriods+1,1,:);

Path=Path(:)';

spath=zeros(N,(nPeriods+1));

for j=1:N
    %for i=1:(nPeriods+1)
        spath(j,:)=Paths(:,1,j);
    %end
end

K1 = 900:25:1000;
K2 = 1000:20:1100;
K3 = 1100:10:1200;
K4 = 1200:5:1400;
K5 = 1400:10:1500;
K6 = 1500:20:1600;
K7 = 1600:25:1700;
Kvec=[K1,K2,K3,K4,K5,K6,K7];
Kvec=unique(Kvec);

T=expr/365;
r=Rate; 
disc = exp(-r*dt);
discc = exp(-r*T);
 [prices_put, stdErrs_put] = Price_MC_American_Strikes_func(spath, disc, 0, Kvec,polydeg );
% 
 prices_eo_put=Price_MC_EO_Strikes_func(spath,discc,0,Kvec);
% 
 [prices_call, stdErrs_call] = Price_MC_American_Strikes_func(spath, disc, 1, Kvec,polydeg );
% 
 prices_eo_call=Price_MC_EO_Strikes_func(spath,discc,1,Kvec);
 
 
filename=['heston_spd_expansion_',num2str(expr),'.mat']; 

 save(filename,'prices_put','stdErrs_put','prices_eo_put','prices_call','stdErrs_call','prices_eo_call')
[f,xi]=ksdensity(spath(1:N,nPeriods+1),400:1:2500);%plot(xi,f);

tvalues = spath(1:N,nPeriods+1);

filename=['heston_den_expansion_',num2str(expr),'.mat'];
save(filename,'xi','f');

filename=['heston_path_expansion_',num2str(expr),'.mat'];
save(filename,'tvalues');

